﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.Scripting;
using TMPro;
using Random = System.Random;

public class ManualGC : MonoBehaviour
{
    public TextMeshProUGUI memoryText;

    // Start is called before the first frame update
    void Awake()
    {
        // Listen on garbage collector mode changes.
        GarbageCollector.GCModeChanged += (GarbageCollector.Mode mode) =>
        {
            Debug.Log("GCModeChanged: " + mode);
        };

        #if !UNITY_EDITOR
        GarbageCollector.GCMode = GarbageCollector.Mode.Disabled;
        #endif
    }
    
    public void CreateGarbage()
    {
        List<WaitForSeconds> tempList = new List<WaitForSeconds>();
        for (int i = 0; i < 100000; i++)
        {
            tempList.Add(new WaitForSeconds(UnityEngine.Random.Range(0.0f, 10.0f)));
        }
    }

    public void ManualGarbageCollection()
    {
        long totalMemory = GC.GetTotalMemory(false);
        float totalMemoryKb = totalMemory * 0.001f;
        float totalMemoryMb = totalMemoryKb * 0.001f;
        float totalMemoryGb = totalMemoryMb * 0.001f;
        //Debug.Log("Total Memory: " + GC.GetTotalMemory(false));
        if(memoryText != null)
            memoryText.text = "Total Memory: " + totalMemoryMb + "MB";
        
        #if !UNITY_EDITOR
        GarbageCollector.GCMode = GarbageCollector.Mode.Manual;
        #endif
        
        GC.Collect();
        
        #if !UNITY_EDITOR
        GarbageCollector.GCMode = GarbageCollector.Mode.Disabled;
        #endif
        
    }

   

    public void CreateLargeArray()
    {
        List<WaitForSeconds> tempList = new List<WaitForSeconds>();
        for (int i = 0; i < 100000; i++)
        {
            tempList.Add(new WaitForSeconds(UnityEngine.Random.Range(0.0f, 10.0f)));
        }
    }

    public void ManualGCOnly()
    {
#if !UNITY_EDITOR
        GC.Collect();
#endif
    }
}
